
Type TDrawingHelper


	Function DrawGeom(geom:TGeom, texture:TImage)
		Local ox:Float, oy:Float
		Local rot:Float
		GetOrigin(ox, oy)
		rot = GetRotation()
		SetOrigin(geom._position.X, geom._position.Y)
		SetRotation(MathHelper.ToDegrees(geom.GetRotation()))
		DrawImage(texture, 0, 0)
		
		SetOrigin(ox, oy)
		SetRotation(rot)
	End Function
	Function CreateLineTexture:TImage(lineThickness:Int, color:TColor)
		Local img:TImage = CreateImage(2, lineThickness + 2)

		Local pix:TPixmap = LockImage(img)
		For Local x:Int = 0 To 1
			For Local y:Int = 0 To lineThickness + 2 - 1
				pix.WritePixel(x, y, color.GetPixel32())
			Next
		Next
		pix.WritePixel(0, 0, TColor.Create(0, 0, 0, 0).GetPixel32())
		pix.WritePixel(1, 0, TColor.Create(0, 0, 0, 0).GetPixel32())
		pix.WritePixel(0, pix.height - 1, TColor.Create(0, 0, 0, 0).GetPixel32())
		pix.WritePixel(1, pix.height - 1, TColor.Create(0, 0, 0, 0).GetPixel32())
		UnlockImage(img)
		Return img
	End Function
	
	Function CreateRectangleTexture:Timage(width:Int, height:Int, color:TColor, borderColor:TColor = Null, borderWidth:Int = 1, borderOuterTransitionWidth:Int = 1, borderInnerTransitionWidth:Int = 1)

		Local x:Int = 0
		Local y:Int = -1
		Local j:Int = 0
		Local count:Int = width * height
		Local shellColor:TColor[] = New TColor[borderWidth + borderOuterTransitionWidth + borderInnerTransitionWidth]
		Local transitionAmount:Float = 0
		
		For j = 0 To borderOuterTransitionWidth - 1
			transitionAmount = Float(j) / Float(borderOuterTransitionWidth)
			shellColor[j] = borderColor.Copy()
			shellColor[j].A = 255 * transitionAmount
		Next
		For j = borderOuterTransitionWidth To borderWidth + borderOuterTransitionWidth - 1
			shellColor[j] = borderColor.Copy()
		Next
		
		For j = borderWidth + borderOuterTransitionWIdth To borderWidth + borderOuterTransitionWidth + borderInnerTransitionWidth - 1
			transitionAmount = 1 - Float(j - (borderWidth + borderOuterTransitionWidth) + 1) / Float(borderInnerTransitionWidth + 1)
			Local col:TColor = TColor.Create(255, 0, 0, 0)
			col.R = MathHelper.Lerp(color.R, borderColor.R, transitionAmount)
			col.G = MathHelper.Lerp(color.G, borderColor.G, transitionAmount)
			col.B = MathHelper.Lerp(color.B, borderColor.B, transitionAmount)
			shellColor[j] = col
			
		Next
		
		Local img:TImage = CreateImage(width, height)
		Local pix:TPixmap = LockImage(img)
		Local finalColor:TColor = TColor.Create(0, 0, 0, 0)
		For Local i:Int = 0 To count - 1
			If i Mod width = 0 Then y:+1
			x = i Mod width
			Local isInShell:Int = False
			For Local k:Int = 0 To shellColor.Length - 1
				If InShell(x, y, width, height, k) Then
					finalColor = shellColor[k]
					isInShell = True
					Exit
				End If
			Next
			If Not isInShell Then
				finalColor = color
			End If
			pix.WritePixel(x, y, finalColor.GetPixel32())
		Next
		
		UnlockImage(img)
		Return img
	End Function
	
	Function CreateCircleTexture:TImage(radius:Int, color:TColor, borderColor:TColor = Null, borderWidth:Int = 1, borderOuterTransitionWidth:Int = 1, borderInnerTransitionWidth:Int = 1)

		Local x:Int = 0
		Local y:Int = -1
		Local diameter:Int = (radius + 2) * 2
		Local center:Vector2 = Vector2.Create((diameter - 1) / 2.0, (diameter - 1) / 2.0)
		Local count:Int = diameter * diameter
		Local img:TImage = CreateImage(diameter, diameter)
		Local pix:TPixmap = LockImage(img)
		Local finalColor:TColor = TColor.Create(0, 0, 0, 0)
		For Local i:Int = 0 To count - 1
			If i Mod diameter = 0 Then y:+1
			x = i Mod diameter
			

			Local diff:Vector2 = Vector2.Create(x, y).Subtract(center)
			Local length:Float = diff.Length()
			
			If length > radius Then
				finalColor = TColor.Create(0, 0, 0, 0)
			Else If length >= radius - borderOuterTransitionWidth Then
				Local transitionAmount:Float = (length - (radius - borderOuterTransitionWidth)) / borderOuterTransitionWidth
				transitionAmount = 255 * (1 - transitionAmount)
				finalColor = TColor.Create(transitionAmount, borderColor.R, borderColor.G, borderColor.B)
			
			Else If length > radius - (borderWidth + borderOuterTransitionWidth) Then
				finalColor = borderColor
			
			Else If length >= radius - (borderWidth + borderOuterTransitionWidth + borderInnerTransitionWidth) Then
				Local transitionAmount:Float = (length - (radius - (borderWidth + borderOuterTransitionWidth + borderInnerTransitionWidth))) / (borderInnerTransitionWidth + 1)
				Local col:TColor = TColor.Create(255, 0, 0, 0)
				col.R = MathHelper.Lerp(color.R, borderColor.R, transitionAmount)
				col.G = MathHelper.Lerp(color.G, borderColor.G, transitionAmount)
				col.B = MathHelper.Lerp(color.B, borderColor.B, transitionAmount)
				finalColor = col
			Else
				finalColor = color
			End If			
			pix.WritePixel(x, y, finalColor.GetPixel32())
		Next
		
		UnlockImage(img)
		Return img
	End Function

	Function CreatePolygonTexture:TImage(points:Vector2[], color:TColor)

		Local vertices:TVertices = TVertices.Create(points)
		Local centroid:Vector2 = vertices.GetCentroid()
		vertices.Translate(centroid.Scale(- 1))
		Local aabb:TAABB = TAABB.CreateFromVertices(vertices)
		Local vArray:Vector2[] = vertices.GetVerticesArray()
		Local minv:Vector2 = aabb.GetMin()
		Local maxv:Vector2 = aabb.GetMax()

		Local leftDist:Float = Abs(centroid.X - minv.X)
		Local rightDist:Float = Abs(maxv.X - centroid.X)
		Local imgWidth:Int
		Local imgHeight:Int
		Local topDist:Float = Abs(centroid.Y - minv.Y)
		Local bottomDist:Float = Abs(maxv.Y - centroid.Y)
		' this centers the poly texture with the centroid at the image center
		' for easier rendering with rotations.
		If leftDist > rightdist Then
			imgWidth = leftDist
		Else
			imgWidth = rightdist
		End If
		
		If topDist > bottomDist Then
			imgHeight = topDist
		Else
			imgHeight = bottomDist
		End If
		imgWidth:*2
		imgHeight:*2

		Local img:TImage = CreateImage(imgWidth, imgHeight)
		Local pix:TPixmap = LockImage(img)
		Local testVec:Vector2 = Vector2.Zero()
		pix.ClearPixels(TColor.MakePixel32(0, 0, 0, 0))
		For Local x:Int = 0 To pix.width - 1
			For Local y:Int = 0 To pix.height - 1
				testVec.X = x - imgWidth / 2
				testVec.Y = y - imgHeight / 2
				If PointInPoly(vArray, testVec) Then
					pix.WritePixel(x, y, color.GetPixel32())
				End If
			Next
		Next
		UnlockImage(img)
		Return img
	End Function
End Type

Private

Function InShell:Int(x:Int, y:Int, width:Int, height:Int, shell:Int)
	'' check each line of rect
	If (x = shell And IsBetween(y, shell, height - 1 - shell)) Or (x = width - 1 - shell And IsBetween(y, shell, height - 1 - shell)) Then
		Return True
	Else If (y = shell And IsBetween(x, shell, width - 1 - shell)) Or (y = height - 1 - shell And IsBetween(x, shell, width - 1 - shell)) Then
		Return True
	End If
	Return False
End Function

Function IsBetween:Int(value:Float, minv:Float, maxv:Float)
	If value >= minv And value <= maxv Then Return True
	Return False
End Function

'point in poly helper functions
Function PointInPoly:Int(vertices:Vector2[], point:Vector2)
	
	Local windNum:Int = 0
	For Local i:Int = 0 To vertices.Length - 1
		Local curPoint:Vector2 = vertices[i]
		Local cross:Int = 0
		If i + 1 < vertices.Length Then
			Local nextPoint:Vector2 = vertices[i + 1]
			cross = EdgeCrossing(point.X, point.Y, curPoint.X, curpoint.Y, nextPoint.X, nextPoint.Y)
		Else ' last edge
			cross = EdgeCrossing(point.X, point.Y, curPoint.X, curPoint.Y, vertices[0].X, vertices[0].Y)
		End If
		
		If cross = 1 Then
			windNum:+1
		ElseIf cross = 2
			windNum:-1
		End If
	Next
	
	If windNum = 0 Then
		Return False
	Else
		Return True
	End If	
End Function

Rem
bbdoc: takes horizontal ray 'r' and checks it with line 1-2
return values: 
0= no crossing
1= upward crossing
2= downward crossing
end rem
Function EdgeCrossing:Int(rx:Float, ry:Float, x1:Float, y1:Float, x2:Float, y2:Float)
	If x1 > rx Or x2 > rx Then ' one of the points is to the right of ray 'r'
		If (ry > y1 And ry <= y2) Or (ry <= y1 And ry > y2) Then	' thel ine is possibly intersecting. (down/up ward)
			If y1 > y2 Then ' upward crossing
				' if the point is to the left of this line then there is a cross			
				Local dir:Int = isLeft(rx, ry, x1, y1, x2, y2)	
				If dir = 0 Then ' there is a cross
					Return 1
				End If
			Else	' downward possible crossing
				'if the point is to the right of this line then the lines cross
				Local dir:Int = isLeft(rx, ry, x1, y1, x2, y2)
				If dir = 1 Then
					Return 2
				End If
			End If
		End If
	End If
	Return 0
End Function

Rem
bbdoc: takes a test point (tx,ty) and determines if it is to the left/right or on an infinite line
returns:
0= left
1 = right
2 = on
end rem
Function isLeft:Int(tx:Float, ty:Float, x1:Float, y1:Float, x2:Float, y2:Float)
	Local value:Float = (x2 - x1) * (ty - y1) - (tx - x1) * (y2 - y1)
	If value = 0 Then
		Return 2	' on the line
	Else If value > 0 Then
		Return 1	'right
	Else If value < 0 Then
		Return 0 'left
	End If
End Function

Public